
/*==================================================================================*/
/*INDONESIA*/
/*==================================================================================*/

cd "C:\Data\Dropbox\Research\2012- Paradoxical Religiosity\Data\Replication Data\"
*cd "N:\Private\"
set more off

use "Merged Dataset.dta", clear
_strip_labels *


tab female if usa==0
tab edu if usa==0
tab relminority if usa==0
sum age if usa==0

alpha rfs1-rfs12 if usa==0
alpha polknowledge polinterest polexposure if usa==0


*drop non-religion and those with missing religious affiliation* 
drop if (noreligion==1 | relminority==. | (noreligion==. & usa==1)) | (usa>0)

*calculate composite scores
egen missexpertise = rowmiss(polknowledge polinterest polexposure)
egen missrfs = rowmiss(rfs1-rfs12)
egen missia = rowmiss(iasocial iaedu iacrime iatax)

egen expertise = rowmean(polknowledge polinterest polexposure)
replace expertise = . if missexpertise>1
egen rfs = rowmean(rfs1-rfs12)
replace rfs = . if missrfs>6
egen ia = rowmean(iasocial iaedu iacrime iatax)
replace ia = . if missia>2

*standardize independent variables*
egen zexpertise = std(expertise)
egen zrfs = std(rfs)
egen zia = std(ia)
egen zedu = std(edu)
egen zage = std(age)

gen usaXtrel = usa*trel
gen usaXtblending = usa*tblending
gen usaXtseparate = usa*tseparate

gen trelXzrfs = trel*zrfs
gen tblendingXzrfs = tblending*zrfs
gen tseparateXzrfs = tseparate*zrfs

gen usaXzrfs = usa*zrfs
gen usaXtrelXzrfs = usa*trel*zrfs
gen usaXtblendingXzrfs = usa*tblending*zrfs
gen usaXtseparateXzrfs = usa*tseparate*zrfs


*set output directory*
cd "C:\Data\Dropbox\Research\2012- Paradoxical Religiosity\Data\Replication Data\Results"


*Supplementary Analysis: Religious Indonesian Sample Only
foreach yvar of varlist voting attitude competence integrity {
	reg `yvar' relminority zedu zage zexpertise zia trel tblending tseparate zrfs
	local p =  Ftail(`e(df_m)',`e(df_r)',`e(F)')
	outreg2 using supp_indo_only, bdec(2) sdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) addstat("F-Test", e(F), "Prob > F", `p') excel append

	reg `yvar' relminority zedu zage zexpertise zia trel tblending tseparate zrfs usaXtrel usaXtblending usaXtseparate trelXzrfs tblendingXzrfs tseparateXzrfs
	local p =  Ftail(`e(df_m)',`e(df_r)',`e(F)')
	outreg2 using supp_indo_only, bdec(2) sdec(2) rdec(2) alpha(.01, .05, .10) addstat("F-Test", e(F), "Prob > F", `p') excel append
}


*Supplementary Analysis: Religious Indonesian Sample Only with Basic Analysis (no control)
foreach yvar of varlist voting attitude competence integrity {
	reg `yvar' trel tblending tseparate
	local p =  Ftail(`e(df_m)',`e(df_r)',`e(F)')
	outreg2 using supp_indo_basic, bdec(2) sdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) addstat("F-Test", e(F), "Prob > F", `p') excel append

	reg `yvar' trel
	local p =  Ftail(`e(df_m)',`e(df_r)',`e(F)')
	outreg2 using supp_indo_basic, bdec(2) sdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) addstat("F-Test", e(F), "Prob > F", `p') excel append

	reg `yvar' tblending tseparate
	local p =  Ftail(`e(df_m)',`e(df_r)',`e(F)')
	outreg2 using supp_indo_basic, bdec(2) sdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) addstat("F-Test", e(F), "Prob > F", `p') excel append
}



/*==================================================================================*/
/*USA*/
/*==================================================================================*/
cd "C:\Data\Dropbox\Research\2012- Paradoxical Religiosity\Data\Replication Data\"
*cd "N:\Private\"
set more off

use "Merged Dataset.dta", clear
_strip_labels *


cd "C:\Data\Dropbox\Research\2012- Paradoxical Religiosity\Data\Replication Data\Results\"


tab female if usa==1
tab edu if usa==1
tab relminority noreligion if usa==1
tab party if usa==1
sum age if usa==1

alpha rfs1-rfs12 if usa==1
alpha polknowledge polinterest polexposure if usa==1

drop if (usa!=1) | (noreligion!=0)


*Supplementary Analysis: Checks of Political Religiosity Treatments
reg relfreedom tblending tseparate
local p =  Ftail(`e(df_m)',`e(df_r)',`e(F)')
outreg2 using supp_usa_check, bdec(2) sdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) addstat("F-Test", e(F), "Prob > F", `p') excel

reg relfreedom trel tblending tseparate
local p =  Ftail(`e(df_m)',`e(df_r)',`e(F)')
outreg2 using supp_usa_check, bdec(2) sdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) addstat("F-Test", e(F), "Prob > F", `p') excel append

reg betteredu tblending tseparate
local p =  Ftail(`e(df_m)',`e(df_r)',`e(F)')
outreg2 using supp_usa_check, bdec(2) sdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) addstat("F-Test", e(F), "Prob > F", `p') excel append

reg betteredu trel tblending tseparate
local p =  Ftail(`e(df_m)',`e(df_r)',`e(F)')
outreg2 using supp_usa_check, bdec(2) sdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) addstat("F-Test", e(F), "Prob > F", `p') excel append



*Supplementary Analysis: Religious American Sample Only with Basic Analysis (no control)
foreach yvar of varlist voting attitude competence integrity {
	reg `yvar' trel tblending tseparate
	local p =  Ftail(`e(df_m)',`e(df_r)',`e(F)')
	outreg2 using supp_usa_basic, bdec(2) sdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) addstat("F-Test", e(F), "Prob > F", `p') excel append

	reg `yvar' trel
	local p =  Ftail(`e(df_m)',`e(df_r)',`e(F)')
	outreg2 using supp_usa_basic, bdec(2) sdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) addstat("F-Test", e(F), "Prob > F", `p') excel append

	reg `yvar' tblending tseparate
	local p =  Ftail(`e(df_m)',`e(df_r)',`e(F)')
	outreg2 using supp_usa_basic, bdec(2) sdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) addstat("F-Test", e(F), "Prob > F", `p') excel append
}



/*==================================================================================*/
/*POWER ANALYSIS*/
/*==================================================================================*/

cd "C:\Data\Dropbox\Research\2012- Paradoxical Religiosity\Data\Replication Data\"
set more off

use "Merged Dataset.dta", clear

*drop non-religion and those with missing religious affiliation* 
drop if (noreligion==1 | relminority==. | (noreligion==. & usa==1))

egen missexpertise = rowmiss(polknowledge polinterest polexposure)
egen missrfs = rowmiss(rfs1-rfs12)
egen missia = rowmiss(iasocial iaedu iacrime iatax)

egen expertise = rowmean(polknowledge polinterest polexposure)
replace expertise = . if missexpertise>1
egen rfs = rowmean(rfs1-rfs12)
replace rfs = . if missrfs>6
egen ia = rowmean(iasocial iaedu iacrime iatax)
replace ia = . if missia>2

*standardize independent variables*
egen zexpertise = std(expertise)
egen zrfs = std(rfs)
egen zia = std(ia)
egen zedu = std(edu)
egen zage = std(age)

*set output directory*
cd "C:\Data\Dropbox\Research\2012- Paradoxical Religiosity\Data\Replication Data\Results"


foreach yvar of varlist voting attitude competence integrity {
	reg `yvar' usa relminority zedu zage zexpertise zia zrfs
	local p =  Ftail(`e(df_m)',`e(df_r)',`e(F)')
	outreg2 using supp_power, bdec(2) sdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) addstat("F-Test", e(F), "Prob > F", `p') excel append

	reg `yvar' usa relminority zedu zage zexpertise zia zrfs trel tblending tseparate
	local p =  Ftail(`e(df_m)',`e(df_r)',`e(F)')
	outreg2 using supp_power, bdec(2) sdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) addstat("F-Test", e(F), "Prob > F", `p') excel append
}

powerreg, r2f(.03) r2r(.0) nvar(3) ntest(3) power(.7)
powerreg, r2f(.03) r2r(.0) nvar(3) ntest(3) power(.8)
powerreg, r2f(.03) r2r(.0) nvar(3) ntest(3) power(.9)
